# Server Files for victorhost.com/posupdate

## Upload these files to your update server

### File Structure:
```
victorhost.com/posupdate/
├── version.json          # Upload this file
├── changelog.json        # Upload this file
└── updates/
    └── update-1.0.1.zip  # Create and upload update packages here
```

### Steps to Deploy:

1. **Upload version.json** to: `https://victorhost.com/posupdate/version.json`
2. **Upload changelog.json** to: `https://victorhost.com/posupdate/changelog.json`
3. **Create updates directory** at: `https://victorhost.com/posupdate/updates/`
4. **Upload update ZIP files** to: `https://victorhost.com/posupdate/updates/update-X.X.X.zip`

### Test URLs:
- Version check: https://victorhost.com/posupdate/version.json
- Changelog: https://victorhost.com/posupdate/changelog.json
- Update file: https://victorhost.com/posupdate/updates/update-1.0.1.zip

### Important:
- All files must be publicly accessible (readable)
- Use proper JSON formatting
- Test URLs in browser before releasing

### When to Update:

**New Version Release:**
1. Change "version" in version.json to new version number
2. Add new entry to TOP of changelog.json array
3. Upload new update-X.X.X.zip file to updates/ folder

**Example for v1.1.0:**
- version.json: Change to "1.1.0"
- changelog.json: Add v1.1.0 entry at top
- Upload: update-1.1.0.zip to updates/

Then all POS systems will automatically detect the new version! 🚀
